; Edit.asm - demonstrates an edit control
;
; Edit controls allow the user to enter text, or edit existing text.
; They can be of arbitrary size and have many abilities, like
; being able to change the font size, do cut copy and paste, etc.
;
; Edit controls contain a large amount of functionality built in,
; as this example will demonstrate. Cut, copy, paste is all taken
; care of for us. In fact, in this example I don't even check any
; messages sent to the parent window by the edit control as there's
; nothing I want to do with them.
;
; See the reference in the help file for all the messages and
; various things you can do with edit controls. For example, you
; can send WM_CUT, WM_COPY and WM_PASTE messages to force a cut
; copy or paste, which is what you might do in response to the
; selection of a menu item.
;

%define _WINMESSAGES_
%include "Gaz\Win32\Include\Windows.inc"

[BITS 32]
[section .text]

ddglobal _gbl_hInstance

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	ddlocal		_hwnd
	struclocal	_wndclass, WNDCLASSEX, _msg, MSG
	endlocals
	WinMainPrologue
	mov	eax, .hInstance
	mov	._gbl_hInstance, eax
	mov	esi, ._wndclass
	mov	edi, ._msg
	mov	[esi + WNDCLASSEX.cbSize], dword WNDCLASSEX_size
	mov	[esi + WNDCLASSEX.style], dword CS_HREDRAW | CS_VREDRAW
	mov	[esi + WNDCLASSEX.lpfnWndProc], dword _WndProc
	mov	[esi + WNDCLASSEX.cbClsExtra], dword 0
	mov	[esi + WNDCLASSEX.cbWndExtra], dword 0
	mov	eax, .hInstance
	mov	[esi + WNDCLASSEX.hInstance], eax
	sc LoadIcon, NULL, IDI_APPLICATION
	mov	[esi + WNDCLASSEX.hIcon], eax
	sc LoadCursor, NULL, IDC_ARROW
	mov	[esi + WNDCLASSEX.hCursor], eax
	sc GetStockObject, WHITE_BRUSH
	mov	[esi + WNDCLASSEX.hbrBackground], eax
	mov	[esi + WNDCLASSEX.lpszMenuName], dword NULL
	TEXTlocal szClassName, 'MyClass',0
	mov	[esi + WNDCLASSEX.lpszClassName], dword .szClassName
	sc RegisterClassEx, esi
	cmp	eax, TRUE
	je	near _WinMain_Fail
	TEXTlocal szWndCaption, 'Edit child window control',0
	sc CreateWindowEx, 0, .szClassName, .szWndCaption, WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, .hInstance, NULL
	mov	._hwnd, eax
	sc ShowWindow, ._hwnd, .nCmdShow
	sc UpdateWindow, ._hwnd
_WinMain_Loop:
	sc GetMessage, ._msg, NULL, 0, 0
	cmp	eax, TRUE
	jne	_WinMain_Loop_End
	sc TranslateMessage, ._msg
	sc DispatchMessage, ._msg
	jmp	_WinMain_Loop
_WinMain_Loop_End:
	mov	eax, [edi + MSG.wParam]
	jmp	_WinMain_End
_WinMain_Fail:
	TEXTlocal szErrorMsg, 'Failed to register window class!',0
	sc MessageBox, NULL, .szErrorMsg, .szWndCaption, MB_ICONERROR
_WinMain_End:
	WinMainEpilogue
endproc
;
;-----------------------------------------------------------------------
;
proc _WndProc, hwnd, message, wParam, lParam
	ddstatic	_hwnd1
	endlocals
	;
	CallbackPrologue
	;
	switch .message
		case WM_CREATE
			;
			; Create an edit control, making it a multiline control
			; (ES_MULTILINE), insert returns into the control (ES_WANTRETURN),
			; having scrollbars (WS_VSCROLL, WS_HSCROLL) and making it keep
			; the selection if it loses focus (eg we Alt-Tab away)
			;
			sc CreateWindowEx, 0, _szClassNameEdit, _szClassNameEdit, WS_CHILDWINDOW | WS_VISIBLE | WS_VSCROLL | WS_HSCROLL | ES_MULTILINE | ES_NOHIDESEL | ES_WANTRETURN, 0, 0, 0, 0, .hwnd, 1, ._gbl_hInstance, NULL
			;
			; Having created the child window, we store it's window handle
			;
			mov	._hwnd1, eax
			xor	eax, eax
			break
		case WM_SIZE
			mov	ebx, .lParam
			movsx	esi, bx
			shr	ebx, 16
			movsx	edi, bx
			sc MoveWindow, ._hwnd1, 0, 0, esi, edi, TRUE
			xor	eax, eax
			break
		case WM_DESTROY
			sc PostQuitMessage, 0
			xor	eax, eax
			break
		default
			sc DefWindowProc, .hwnd, .message, .wParam, .lParam
	switchend
	;
	CallbackEpilogue
endproc
;
;-----------------------------------------------------------------------
;
[section .bss]

[section .data]
